/*!
 * GMaps.js v0.4.5
 * http://hpneo.github.com/gmaps/
 *
 * Copyright 2013, Gustavo Leon
 * Released under the MIT License.
 */
;if(!(typeof window.google==="object"&&window.google.maps)){throw"Google Maps API is required. Please register the following JavaScript library http://maps.google.com/maps/api/js?sensor=true."}var extend_object=function(b,c){var a;if(b===c){return b}for(a in c){b[a]=c[a]}return b};var replace_object=function(c,b){var a;if(c===b){return c}for(a in b){if(c[a]!=undefined){c[a]=b[a]}}return c};var array_map=function(g,f){var b=Array.prototype.slice.call(arguments,2),d=[],a=g.length,c;if(Array.prototype.map&&g.map===Array.prototype.map){d=Array.prototype.map.call(g,function(h){callback_params=b;callback_params.splice(0,0,h);return f.apply(this,callback_params)})}else{for(c=0;c<a;c++){callback_params=b;callback_params.splice(0,0,g[c]);d.push(f.apply(this,callback_params))}}return d};var array_flat=function(c){var b=[],a;for(a=0;a<c.length;a++){b=b.concat(c[a])}return b};var coordsToLatLngs=function(b,c){var d=b[0],a=b[1];if(c){d=b[1];a=b[0]}return new google.maps.LatLng(d,a)};var arrayToLatLng=function(b,c){var a;for(a=0;a<b.length;a++){if(b[a].length>0&&typeof(b[a][0])!="number"){b[a]=arrayToLatLng(b[a],c)}else{b[a]=coordsToLatLngs(b[a],c)}}return b};var getElementById=function(c,b){var a,c=c.replace("#","");if("jQuery" in this&&b){a=$("#"+c,b)[0]}else{a=document.getElementById(c)}return a};var findAbsolutePosition=function(b){var c=0,a=0;if(b.offsetParent){do{c+=b.offsetLeft;a+=b.offsetTop}while(b=b.offsetParent)}return[c,a]};var GMaps=(function(b){var c=document;var a=function(k){k.zoom=k.zoom||15;k.mapType=k.mapType||"roadmap";var z=this,B,m=["bounds_changed","center_changed","click","dblclick","drag","dragend","dragstart","idle","maptypeid_changed","projection_changed","resize","tilesloaded","zoom_changed"],q=["mousemove","mouseout","mouseover"],s=["el","lat","lng","mapType","width","height","markerClusterer","enableNewStyle"],C=k.el||k.div,o=k.markerClusterer,D=google.maps.MapTypeId[k.mapType.toUpperCase()],x=new google.maps.LatLng(k.lat,k.lng),G=k.zoomControl||true,f=k.zoomControlOpt||{style:"DEFAULT",position:"TOP_LEFT"},A=f.style||"DEFAULT",g=f.position||"TOP_LEFT",t=k.panControl||true,n=k.mapTypeControl||true,r=k.scaleControl||true,p=k.streetViewControl||true,l=l||true,y={},v={zoom:this.zoom,center:x,mapTypeId:D},d={panControl:t,zoomControl:G,zoomControlOptions:{style:google.maps.ZoomControlStyle[A],position:google.maps.ControlPosition[g]},mapTypeControl:n,scaleControl:r,streetViewControl:p,overviewMapControl:l};if(typeof(k.el)==="string"||typeof(k.div)==="string"){this.el=getElementById(C,k.context)}else{this.el=C}if(typeof(this.el)==="undefined"||this.el===null){throw"No element defined."}window.context_menu=window.context_menu||{};window.context_menu[z.el.id]={};this.controls=[];this.overlays=[];this.layers=[];this.singleLayers={};this.markers=[];this.polylines=[];this.routes=[];this.polygons=[];this.infoWindow=null;this.overlay_el=null;this.zoom=k.zoom;this.registered_events={};this.el.style.width=k.width||this.el.scrollWidth||this.el.offsetWidth;this.el.style.height=k.height||this.el.scrollHeight||this.el.offsetHeight;google.maps.visualRefresh=k.enableNewStyle;for(B=0;B<s.length;B++){delete k[s[B]]}if(k.disableDefaultUI!=true){v=extend_object(v,d)}y=extend_object(v,k);for(B=0;B<m.length;B++){delete y[m[B]]}for(B=0;B<q.length;B++){delete y[q[B]]}this.map=new google.maps.Map(this.el,y);if(o){this.markerClusterer=o.apply(this,[this.map])}var u=function(L,Q){var P="",U=window.context_menu[z.el.id][L];for(var M in U){if(U.hasOwnProperty(M)){var O=U[M];P+='<li><a id="'+L+"_"+M+'" href="#">'+O.title+"</a></li>"}}if(!getElementById("gmaps_context_menu")){return}var R=getElementById("gmaps_context_menu");R.innerHTML=P;var H=R.getElementsByTagName("a"),T=H.length;M;for(M=0;M<T;M++){var J=H[M];var K=function(i){i.preventDefault();U[this.id.replace(L+"_","")].action.apply(z,[Q]);z.hideContextMenu()};google.maps.event.clearListeners(J,"click");google.maps.event.addDomListenerOnce(J,"click",K,false)}var N=findAbsolutePosition.apply(this,[z.el]),I=N[0]+Q.pixel.x-15,S=N[1]+Q.pixel.y-15;R.style.left=I+"px";R.style.top=S+"px";R.style.display="block"};this.buildContextMenu=function(I,H){if(I==="marker"){H.pixel={};var i=new google.maps.OverlayView();i.setMap(z.map);i.draw=function(){var K=i.getProjection(),J=H.marker.getPosition();H.pixel=K.fromLatLngToContainerPixel(J);u(I,H)}}else{u(I,H)}};this.setContextMenu=function(H){window.context_menu[z.el.id][H.control]={};var J,I=c.createElement("ul");for(J in H.options){if(H.options.hasOwnProperty(J)){var K=H.options[J];window.context_menu[z.el.id][H.control][K.name]={title:K.title,action:K.action}}}I.id="gmaps_context_menu";I.style.display="none";I.style.position="absolute";I.style.minWidth="100px";I.style.background="white";I.style.listStyle="none";I.style.padding="8px";I.style.boxShadow="2px 2px 6px #ccc";c.body.appendChild(I);var L=getElementById("gmaps_context_menu");google.maps.event.addDomListener(L,"mouseout",function(i){if(!i.relatedTarget||!this.contains(i.relatedTarget)){window.setTimeout(function(){L.style.display="none"},400)}},false)};this.hideContextMenu=function(){var i=getElementById("gmaps_context_menu");if(i){i.style.display="none"}};var w=function(H,i){google.maps.event.addListener(H,i,function(I){if(I==undefined){I=this}k[i].apply(this,[I]);z.hideContextMenu()})};for(var E=0;E<m.length;E++){var F=m[E];if(F in k){w(this.map,F)}}for(var E=0;E<q.length;E++){var F=q[E];if(F in k){w(this.map,F)}}google.maps.event.addListener(this.map,"rightclick",function(i){if(k.rightclick){k.rightclick.apply(this,[i])}if(window.context_menu[z.el.id]["map"]!=undefined){z.buildContextMenu("map",i)}});this.refresh=function(){google.maps.event.trigger(this.map,"resize")};this.fitZoom=function(){var J=[],H=this.markers.length,I;for(I=0;I<H;I++){J.push(this.markers[I].getPosition())}this.fitLatLngBounds(J)};this.fitLatLngBounds=function(K){var J=K.length;var I=new google.maps.LatLngBounds();for(var H=0;H<J;H++){I.extend(K[H])}this.map.fitBounds(I)};this.setCenter=function(H,i,I){this.map.panTo(new google.maps.LatLng(H,i));if(I){I()}};this.getElement=function(){return this.el};this.zoomIn=function(i){i=i||1;this.zoom=this.map.getZoom()+i;this.map.setZoom(this.zoom)};this.zoomOut=function(i){i=i||1;this.zoom=this.map.getZoom()-i;this.map.setZoom(this.zoom)};var j=[],h;for(h in this.map){if(typeof(this.map[h])=="function"&&!this[h]){j.push(h)}}for(B=0;B<j.length;B++){(function(i,I,H){i[H]=function(){return I[H].apply(I,arguments)}})(this,this.map,j[B])}};return a})(this);GMaps.prototype.createControl=function(a){var d=document.createElement("div");d.style.cursor="pointer";d.style.fontFamily="Arial, sans-serif";d.style.fontSize="13px";d.style.boxShadow="rgba(0, 0, 0, 0.398438) 0px 2px 4px";for(var b in a.style){d.style[b]=a.style[b]}if(a.id){d.id=a.id}if(a.classes){d.className=a.classes}if(a.content){d.innerHTML=a.content}for(var c in a.events){(function(g,f){google.maps.event.addDomListener(g,f,function(){a.events[f].apply(this,[this])})})(d,c)}d.index=1;return d};GMaps.prototype.addControl=function(b){var a=google.maps.ControlPosition[b.position.toUpperCase()];delete b.position;var c=this.createControl(b);this.controls.push(c);this.map.controls[a].push(c);return c};GMaps.prototype.createMarker=function(m){if(m.lat==undefined&&m.lng==undefined&&m.position==undefined){throw"No latitude or longitude defined."}var l=this,b=m.details,g=m.fences,i=m.outside,f={position:new google.maps.LatLng(m.lat,m.lng),map:null};delete m.lat;delete m.lng;delete m.fences;delete m.outside;var c=extend_object(f,m),h=new google.maps.Marker(c);h.fences=g;if(m.infoWindow){h.infoWindow=new google.maps.InfoWindow(m.infoWindow);var a=["closeclick","content_changed","domready","position_changed","zindex_changed"];for(var j=0;j<a.length;j++){(function(o,n){if(m.infoWindow[n]){google.maps.event.addListener(o,n,function(p){m.infoWindow[n].apply(this,[p])})}})(h.infoWindow,a[j])}}var k=["animation_changed","clickable_changed","cursor_changed","draggable_changed","flat_changed","icon_changed","position_changed","shadow_changed","shape_changed","title_changed","visible_changed","zindex_changed"];var d=["dblclick","drag","dragend","dragstart","mousedown","mouseout","mouseover","mouseup"];for(var j=0;j<k.length;j++){(function(o,n){if(m[n]){google.maps.event.addListener(o,n,function(){m[n].apply(this,[this])})}})(h,k[j])}for(var j=0;j<d.length;j++){(function(p,o,n){if(m[n]){google.maps.event.addListener(o,n,function(q){if(!q.pixel){q.pixel=p.getProjection().fromLatLngToPoint(q.latLng)}m[n].apply(this,[q])})}})(this.map,h,d[j])}google.maps.event.addListener(h,"click",function(){this.details=b;if(m.click){m.click.apply(this,[this])}if(h.infoWindow){l.hideInfoWindows();h.infoWindow.open(l.map,h)}});google.maps.event.addListener(h,"rightclick",function(n){n.marker=this;if(m.rightclick){m.rightclick.apply(this,[n])}if(window.context_menu[l.el.id]["marker"]!=undefined){l.buildContextMenu("marker",n)}});if(h.fences){google.maps.event.addListener(h,"dragend",function(){l.checkMarkerGeofence(h,function(n,o){i(n,o)})})}return h};GMaps.prototype.addMarker=function(b){var a;if(b.hasOwnProperty("gm_accessors_")){a=b}else{if((b.hasOwnProperty("lat")&&b.hasOwnProperty("lng"))||b.position){a=this.createMarker(b)}else{throw"No latitude or longitude defined."}}a.setMap(this.map);if(this.markerClusterer){this.markerClusterer.addMarker(a)}this.markers.push(a);GMaps.fire("marker_added",a,this);return a};GMaps.prototype.addMarkers=function(c){for(var b=0,a;a=c[b];b++){this.addMarker(a)}return this.markers};GMaps.prototype.hideInfoWindows=function(){for(var b=0,a;a=this.markers[b];b++){if(a.infoWindow){a.infoWindow.close()}}};GMaps.prototype.removeMarker=function(a){for(var b=0;b<this.markers.length;b++){if(this.markers[b]===a){this.markers[b].setMap(null);this.markers.splice(b,1);GMaps.fire("marker_removed",a,this);break}}return a};GMaps.prototype.removeMarkers=function(c){var c=(c||this.markers);for(var b=0;b<this.markers.length;b++){if(this.markers[b]===c[b]){this.markers[b].setMap(null)}}var a=[];for(var b=0;b<this.markers.length;b++){if(this.markers[b].getMap()!=null){a.push(this.markers[b])}}this.markers=a};GMaps.prototype.drawOverlay=function(b){var a=new google.maps.OverlayView(),c=true;a.setMap(this.map);if(b.auto_show!=null){c=b.auto_show}a.onAdd=function(){var h=document.createElement("div");h.style.borderStyle="none";h.style.borderWidth="0px";h.style.position="absolute";h.style.zIndex=100;h.innerHTML=b.content;a.el=h;if(!b.layer){b.layer="overlayLayer"}var g=this.getPanes(),d=g[b.layer],f=["contextmenu","DOMMouseScroll","dblclick","mousedown"];d.appendChild(h);for(var i=0;i<f.length;i++){(function(k,j){google.maps.event.addDomListener(k,j,function(l){if(navigator.userAgent.toLowerCase().indexOf("msie")!=-1&&document.all){l.cancelBubble=true;l.returnValue=false}else{l.stopPropagation()}})})(h,f[i])}google.maps.event.trigger(this,"ready")};a.draw=function(){var d=this.getProjection(),g=d.fromLatLngToDivPixel(new google.maps.LatLng(b.lat,b.lng));b.horizontalOffset=b.horizontalOffset||0;b.verticalOffset=b.verticalOffset||0;var h=a.el,i=h.children[0],f=i.clientHeight,j=i.clientWidth;switch(b.verticalAlign){case"top":h.style.top=(g.y-f+b.verticalOffset)+"px";break;default:case"middle":h.style.top=(g.y-(f/2)+b.verticalOffset)+"px";break;case"bottom":h.style.top=(g.y+b.verticalOffset)+"px";break}switch(b.horizontalAlign){case"left":h.style.left=(g.x-j+b.horizontalOffset)+"px";break;default:case"center":h.style.left=(g.x-(j/2)+b.horizontalOffset)+"px";break;case"right":h.style.left=(g.x+b.horizontalOffset)+"px";break}h.style.display=c?"block":"none";if(!c){b.show.apply(this,[h])}};a.onRemove=function(){var d=a.el;if(b.remove){b.remove.apply(this,[d])}else{a.el.parentNode.removeChild(a.el);a.el=null}};this.overlays.push(a);return a};GMaps.prototype.removeOverlay=function(a){for(var b=0;b<this.overlays.length;b++){if(this.overlays[b]===a){this.overlays[b].setMap(null);this.overlays.splice(b,1);break}}};GMaps.prototype.removeOverlays=function(){for(var a=0,b;b=this.overlays[a];a++){b.setMap(null)}this.overlays=[]};GMaps.prototype.drawPolyline=function(k){var j=[],g=k.path;if(g.length){if(g[0][0]===undefined){j=g}else{for(var b=0,a;a=g[b];b++){j.push(new google.maps.LatLng(a[0],a[1]))}}}var c={map:this.map,path:j,strokeColor:k.strokeColor,strokeOpacity:k.strokeOpacity,strokeWeight:k.strokeWeight,geodesic:k.geodesic,clickable:true,editable:false,visible:true};if(k.hasOwnProperty("clickable")){c.clickable=k.clickable}if(k.hasOwnProperty("editable")){c.editable=k.editable}if(k.hasOwnProperty("icons")){c.icons=k.icons}if(k.hasOwnProperty("zIndex")){c.zIndex=k.zIndex}var f=new google.maps.Polyline(c);var h=["click","dblclick","mousedown","mousemove","mouseout","mouseover","mouseup","rightclick"];for(var d=0;d<h.length;d++){(function(l,i){if(k[i]){google.maps.event.addListener(l,i,function(m){k[i].apply(this,[m])})}})(f,h[d])}this.polylines.push(f);GMaps.fire("polyline_added",f,this);return f};GMaps.prototype.removePolyline=function(a){for(var b=0;b<this.polylines.length;b++){if(this.polylines[b]===a){this.polylines[b].setMap(null);this.polylines.splice(b,1);GMaps.fire("polyline_removed",a,this);break}}};GMaps.prototype.removePolylines=function(){for(var a=0,b;b=this.polylines[a];a++){b.setMap(null)}this.polylines=[]};GMaps.prototype.drawCircle=function(a){a=extend_object({map:this.map,center:new google.maps.LatLng(a.lat,a.lng)},a);delete a.lat;delete a.lng;var b=new google.maps.Circle(a),d=["click","dblclick","mousedown","mousemove","mouseout","mouseover","mouseup","rightclick"];for(var c=0;c<d.length;c++){(function(g,f){if(a[f]){google.maps.event.addListener(g,f,function(h){a[f].apply(this,[h])})}})(b,d[c])}this.polygons.push(b);return b};GMaps.prototype.drawRectangle=function(a){a=extend_object({map:this.map},a);var d=new google.maps.LatLngBounds(new google.maps.LatLng(a.bounds[0][0],a.bounds[0][1]),new google.maps.LatLng(a.bounds[1][0],a.bounds[1][1]));a.bounds=d;var b=new google.maps.Rectangle(a),f=["click","dblclick","mousedown","mousemove","mouseout","mouseover","mouseup","rightclick"];for(var c=0;c<f.length;c++){(function(h,g){if(a[g]){google.maps.event.addListener(h,g,function(i){a[g].apply(this,[i])})}})(b,f[c])}this.polygons.push(b);return b};GMaps.prototype.drawPolygon=function(a){var d=false;if(a.hasOwnProperty("useGeoJSON")){d=a.useGeoJSON}delete a.useGeoJSON;a=extend_object({map:this.map},a);if(d==false){a.paths=[a.paths.slice(0)]}if(a.paths.length>0){if(a.paths[0].length>0){a.paths=array_flat(array_map(a.paths,arrayToLatLng,d))}}var b=new google.maps.Polygon(a),f=["click","dblclick","mousedown","mousemove","mouseout","mouseover","mouseup","rightclick"];for(var c=0;c<f.length;c++){(function(h,g){if(a[g]){google.maps.event.addListener(h,g,function(i){a[g].apply(this,[i])})}})(b,f[c])}this.polygons.push(b);GMaps.fire("polygon_added",b,this);return b};GMaps.prototype.removePolygon=function(b){for(var a=0;a<this.polygons.length;a++){if(this.polygons[a]===b){this.polygons[a].setMap(null);this.polygons.splice(a,1);GMaps.fire("polygon_removed",b,this);break}}};GMaps.prototype.removePolygons=function(){for(var a=0,b;b=this.polygons[a];a++){b.setMap(null)}this.polygons=[]};GMaps.prototype.getFromFusionTables=function(b){var d=b.events;delete b.events;var a=b,c=new google.maps.FusionTablesLayer(a);for(var f in d){(function(h,g){google.maps.event.addListener(h,g,function(i){d[g].apply(this,[i])})})(c,f)}this.layers.push(c);return c};GMaps.prototype.loadFromFusionTables=function(a){var b=this.getFromFusionTables(a);b.setMap(this.map);return b};GMaps.prototype.getFromKML=function(b){var a=b.url,d=b.events;delete b.url;delete b.events;var g=b,c=new google.maps.KmlLayer(a,g);for(var f in d){(function(i,h){google.maps.event.addListener(i,h,function(j){d[h].apply(this,[j])})})(c,f)}this.layers.push(c);return c};GMaps.prototype.loadFromKML=function(a){var b=this.getFromKML(a);b.setMap(this.map);return b};GMaps.prototype.addLayer=function(c,b){b=b||{};var d;switch(c){case"weather":this.singleLayers.weather=d=new google.maps.weather.WeatherLayer();break;case"clouds":this.singleLayers.clouds=d=new google.maps.weather.CloudLayer();break;case"traffic":this.singleLayers.traffic=d=new google.maps.TrafficLayer();break;case"transit":this.singleLayers.transit=d=new google.maps.TransitLayer();break;case"bicycling":this.singleLayers.bicycling=d=new google.maps.BicyclingLayer();break;case"panoramio":this.singleLayers.panoramio=d=new google.maps.panoramio.PanoramioLayer();d.setTag(b.filter);delete b.filter;if(b.click){google.maps.event.addListener(d,"click",function(g){b.click(g);delete b.click})}break;case"places":this.singleLayers.places=d=new google.maps.places.PlacesService(this.map);if(b.search||b.nearbySearch){var a={bounds:b.bounds||null,keyword:b.keyword||null,location:b.location||null,name:b.name||null,radius:b.radius||null,rankBy:b.rankBy||null,types:b.types||null};if(b.search){d.search(a,b.search)}if(b.nearbySearch){d.nearbySearch(a,b.nearbySearch)}}if(b.textSearch){var f={bounds:b.bounds||null,location:b.location||null,query:b.query||null,radius:b.radius||null};d.textSearch(f,b.textSearch)}break}if(d!==undefined){if(typeof d.setOptions=="function"){d.setOptions(b)}if(typeof d.setMap=="function"){d.setMap(this.map)}return d}};GMaps.prototype.removeLayer=function(b){if(typeof(b)=="string"&&this.singleLayers[b]!==undefined){this.singleLayers[b].setMap(null);delete this.singleLayers[b]}else{for(var a=0;a<this.layers.length;a++){if(this.layers[a]===b){this.layers[a].setMap(null);this.layers.splice(a,1);break}}}};var travelMode,unitSystem;GMaps.prototype.getRoutes=function(f){switch(f.travelMode){case"bicycling":travelMode=google.maps.TravelMode.BICYCLING;break;case"transit":travelMode=google.maps.TravelMode.TRANSIT;break;case"driving":travelMode=google.maps.TravelMode.DRIVING;break;default:travelMode=google.maps.TravelMode.WALKING;break}if(f.unitSystem==="imperial"){unitSystem=google.maps.UnitSystem.IMPERIAL}else{unitSystem=google.maps.UnitSystem.METRIC}var d={avoidHighways:false,avoidTolls:false,optimizeWaypoints:false,waypoints:[]},c=extend_object(d,f);c.origin=/string/.test(typeof f.origin)?f.origin:new google.maps.LatLng(f.origin[0],f.origin[1]);c.destination=/string/.test(typeof f.destination)?f.destination:new google.maps.LatLng(f.destination[0],f.destination[1]);c.travelMode=travelMode;c.unitSystem=unitSystem;delete c.callback;var b=this,a=new google.maps.DirectionsService();a.route(c,function(g,h){if(h===google.maps.DirectionsStatus.OK){for(var i in g.routes){if(g.routes.hasOwnProperty(i)){b.routes.push(g.routes[i])}}}if(f.callback){f.callback(b.routes)}})};GMaps.prototype.removeRoutes=function(){this.routes=[]};GMaps.prototype.getElevations=function(b){b=extend_object({locations:[],path:false,samples:256},b);if(b.locations.length>0){if(b.locations[0].length>0){b.locations=array_flat(array_map([b.locations],arrayToLatLng,false))}}var d=b.callback;delete b.callback;var a=new google.maps.ElevationService();if(!b.path){delete b.path;delete b.samples;a.getElevationForLocations(b,function(f,g){if(d&&typeof(d)==="function"){d(f,g)}})}else{var c={path:b.locations,samples:b.samples};a.getElevationAlongPath(c,function(f,g){if(d&&typeof(d)==="function"){d(f,g)}})}};GMaps.prototype.cleanRoute=GMaps.prototype.removePolylines;GMaps.prototype.drawRoute=function(b){var a=this;this.getRoutes({origin:b.origin,destination:b.destination,travelMode:b.travelMode,waypoints:b.waypoints,unitSystem:b.unitSystem,callback:function(c){if(c.length>0){a.drawPolyline({path:c[c.length-1].overview_path,strokeColor:b.strokeColor,strokeOpacity:b.strokeOpacity,strokeWeight:b.strokeWeight});if(b.callback){b.callback(c[c.length-1])}}}})};GMaps.prototype.travelRoute=function(b){if(b.origin&&b.destination){this.getRoutes({origin:b.origin,destination:b.destination,travelMode:b.travelMode,waypoints:b.waypoints,callback:function(k){if(k.length>0&&b.start){b.start(k[k.length-1])}if(k.length>0&&b.step){var g=k[k.length-1];if(g.legs.length>0){var f=g.legs[0].steps;for(var h=0,j;j=f[h];h++){j.step_number=h;b.step(j,(g.legs[0].steps.length-1))}}}if(k.length>0&&b.end){b.end(k[k.length-1])}}})}else{if(b.route){if(b.route.legs.length>0){var a=b.route.legs[0].steps;for(var c=0,d;d=a[c];c++){d.step_number=c;b.step(d)}}}}};GMaps.prototype.drawSteppedRoute=function(c){var b=this;if(c.origin&&c.destination){this.getRoutes({origin:c.origin,destination:c.destination,travelMode:c.travelMode,waypoints:c.waypoints,callback:function(l){if(l.length>0&&c.start){c.start(l[l.length-1])}if(l.length>0&&c.step){var h=l[l.length-1];if(h.legs.length>0){var g=h.legs[0].steps;for(var j=0,k;k=g[j];j++){k.step_number=j;b.drawPolyline({path:k.path,strokeColor:c.strokeColor,strokeOpacity:c.strokeOpacity,strokeWeight:c.strokeWeight});c.step(k,(h.legs[0].steps.length-1))}}}if(l.length>0&&c.end){c.end(l[l.length-1])}}})}else{if(c.route){if(c.route.legs.length>0){var a=c.route.legs[0].steps;for(var d=0,f;f=a[d];d++){f.step_number=d;b.drawPolyline({path:f.path,strokeColor:c.strokeColor,strokeOpacity:c.strokeOpacity,strokeWeight:c.strokeWeight});c.step(f)}}}}};GMaps.Route=function(a){this.origin=a.origin;this.destination=a.destination;this.waypoints=a.waypoints;this.map=a.map;this.route=a.route;this.step_count=0;this.steps=this.route.legs[0].steps;this.steps_length=this.steps.length;this.polyline=this.map.drawPolyline({path:new google.maps.MVCArray(),strokeColor:a.strokeColor,strokeOpacity:a.strokeOpacity,strokeWeight:a.strokeWeight}).getPath()};GMaps.Route.prototype.getRoute=function(b){var a=this;this.map.getRoutes({origin:this.origin,destination:this.destination,travelMode:b.travelMode,waypoints:this.waypoints||[],callback:function(){a.route=e[0];if(b.callback){b.callback.call(a)}}})};GMaps.Route.prototype.back=function(){if(this.step_count>0){this.step_count--;var b=this.route.legs[0].steps[this.step_count].path;for(var a in b){if(b.hasOwnProperty(a)){this.polyline.pop()}}}};GMaps.Route.prototype.forward=function(){if(this.step_count<this.steps_length){var b=this.route.legs[0].steps[this.step_count].path;for(var a in b){if(b.hasOwnProperty(a)){this.polyline.push(b[a])}}this.step_count++}};GMaps.prototype.checkGeofence=function(b,a,c){return c.containsLatLng(new google.maps.LatLng(b,a))};GMaps.prototype.checkMarkerGeofence=function(a,c){if(a.fences){for(var b=0,d;d=a.fences[b];b++){var f=a.getPosition();if(!this.checkGeofence(f.lat(),f.lng(),d)){c(a,d)}}}};GMaps.prototype.toImage=function(b){var b=b||{},d={};d.size=b.size||[this.el.clientWidth,this.el.clientHeight];d.lat=this.getCenter().lat();d.lng=this.getCenter().lng();if(this.markers.length>0){d.markers=[];for(var c=0;c<this.markers.length;c++){d.markers.push({lat:this.markers[c].getPosition().lat(),lng:this.markers[c].getPosition().lng()})}}if(this.polylines.length>0){var a=this.polylines[0];d.polyline={};d.polyline["path"]=google.maps.geometry.encoding.encodePath(a.getPath());d.polyline["strokeColor"]=a.strokeColor;d.polyline["strokeOpacity"]=a.strokeOpacity;d.polyline["strokeWeight"]=a.strokeWeight}return GMaps.staticMapURL(d)};GMaps.staticMapURL=function(b){var f=[],u,c="http://maps.googleapis.com/maps/api/staticmap";if(b.url){c=b.url;delete b.url}c+="?";var s=b.markers;delete b.markers;if(!s&&b.marker){s=[b.marker];delete b.marker}var n=b.polyline;delete b.polyline;if(b.center){f.push("center="+b.center);delete b.center}else{if(b.address){f.push("center="+b.address);delete b.address}else{if(b.lat){f.push(["center=",b.lat,",",b.lng].join(""));delete b.lat;delete b.lng}else{if(b.visible){var a=encodeURI(b.visible.join("|"));f.push("visible="+a)}}}}var l=b.size;if(l){if(l.join){l=l.join("x")}delete b.size}else{l="630x300"}f.push("size="+l);if(!b.zoom){b.zoom=15}var t=b.hasOwnProperty("sensor")?!!b.sensor:true;delete b.sensor;f.push("sensor="+t);for(var g in b){if(b.hasOwnProperty(g)){f.push(g+"="+b[g])}}if(s){var h,k;for(var q=0;u=s[q];q++){h=[];if(u.size&&u.size!=="normal"){h.push("size:"+u.size)}else{if(u.icon){h.push("icon:"+encodeURI(u.icon))}}if(u.color){h.push("color:"+u.color.replace("#","0x"))}if(u.label){h.push("label:"+u.label[0].toUpperCase())}k=(u.address?u.address:u.lat+","+u.lng);if(h.length||q===0){h.push(k);h=h.join("|");f.push("markers="+encodeURI(h))}else{h=f.pop()+encodeURI("|"+k);f.push(h)}}}function r(i,j){if(i[0]==="#"){i=i.replace("#","0x");if(j){j=parseFloat(j);j=Math.min(1,Math.max(j,0));if(j===0){return"0x00000000"}j=(j*255).toString(16);if(j.length===1){j+=j}i=i.slice(0,8)+j}}return i}if(n){u=n;n=[];if(u.strokeWeight){n.push("weight:"+parseInt(u.strokeWeight,10))}if(u.strokeColor){var o=r(u.strokeColor,u.strokeOpacity);n.push("color:"+o)}if(u.fillColor){var v=r(u.fillColor,u.fillOpacity);n.push("fillcolor:"+v)}var m=u.path;if(m.join){for(var p=0,d;d=m[p];p++){n.push(d.join(","))}}else{n.push("enc:"+m)}n=n.join("|");f.push("path="+encodeURI(n))}f=f.join("&");return c+f};GMaps.prototype.addMapType=function(a,b){if(b.hasOwnProperty("getTileUrl")&&typeof(b.getTileUrl)=="function"){b.tileSize=b.tileSize||new google.maps.Size(256,256);var c=new google.maps.ImageMapType(b);this.map.mapTypes.set(a,c)}else{throw"'getTileUrl' function required."}};GMaps.prototype.addOverlayMapType=function(a){if(a.hasOwnProperty("getTile")&&typeof(a.getTile)=="function"){var b=a.index;delete a.index;this.map.overlayMapTypes.insertAt(b,a)}else{throw"'getTile' function required."}};GMaps.prototype.removeOverlayMapType=function(a){this.map.overlayMapTypes.removeAt(a)};GMaps.prototype.addStyle=function(b){var a=new google.maps.StyledMapType(b.styles,b.styledMapName);this.map.mapTypes.set(b.mapTypeId,a)};GMaps.prototype.setStyle=function(a){this.map.setMapTypeId(a)};GMaps.prototype.createPanorama=function(a){if(!a.hasOwnProperty("lat")||!a.hasOwnProperty("lng")){a.lat=this.getCenter().lat();a.lng=this.getCenter().lng()}this.panorama=GMaps.createPanorama(a);this.map.setStreetView(this.panorama);return this.panorama};GMaps.createPanorama=function(b){var f=getElementById(b.el,b.context);b.position=new google.maps.LatLng(b.lat,b.lng);delete b.el;delete b.context;delete b.lat;delete b.lng;var g=["closeclick","links_changed","pano_changed","position_changed","pov_changed","resize","visible_changed"],a=extend_object({visible:true},b);for(var d=0;d<g.length;d++){delete a[g[d]]}var c=new google.maps.StreetViewPanorama(f,a);for(var d=0;d<g.length;d++){(function(i,h){if(b[h]){google.maps.event.addListener(i,h,function(){b[h].apply(this)})}})(c,g[d])}return c};GMaps.prototype.on=function(b,a){return GMaps.on(b,this,a)};GMaps.prototype.off=function(a){GMaps.off(a,this)};GMaps.custom_events=["marker_added","marker_removed","polyline_added","polyline_removed","polygon_added","polygon_removed","geolocated","geolocation_failed"];GMaps.on=function(d,a,c){if(GMaps.custom_events.indexOf(d)==-1){return google.maps.event.addListener(a,d,c)}else{var b={handler:c,eventName:d};a.registered_events[d]=a.registered_events[d]||[];a.registered_events[d].push(b);return b}};GMaps.off=function(b,a){if(GMaps.custom_events.indexOf(b)==-1){google.maps.event.clearListeners(a,b)}else{a.registered_events[b]=[]}};GMaps.fire=function(f,a,d){if(GMaps.custom_events.indexOf(f)==-1){google.maps.event.trigger(a,f,Array.prototype.slice.apply(arguments).slice(2))}else{if(f in d.registered_events){var c=d.registered_events[f];for(var b=0;b<c.length;b++){(function(i,h,g){i.apply(h,[g])})(c[b]["handler"],d,a)}}}};GMaps.geolocate=function(a){var b=a.always||a.complete;if(navigator.geolocation){navigator.geolocation.getCurrentPosition(function(c){a.success(c);if(b){b()}},function(c){a.error(c);if(b){b()}},a.options)}else{a.not_supported();if(b){b()}}};GMaps.geocode=function(a){this.geocoder=new google.maps.Geocoder();var b=a.callback;if(a.hasOwnProperty("lat")&&a.hasOwnProperty("lng")){a.latLng=new google.maps.LatLng(a.lat,a.lng)}delete a.lat;delete a.lng;delete a.callback;this.geocoder.geocode(a,function(d,c){b(d,c)})};if(!google.maps.Polygon.prototype.getBounds){google.maps.Polygon.prototype.getBounds=function(c){var b=new google.maps.LatLngBounds();var g=this.getPaths();var f;for(var d=0;d<g.getLength();d++){f=g.getAt(d);for(var a=0;a<f.getLength();a++){b.extend(f.getAt(a))}}return b}}if(!google.maps.Polygon.prototype.containsLatLng){google.maps.Polygon.prototype.containsLatLng=function(f){var a=this.getBounds();if(a!==null&&!a.contains(f)){return false}var c=false;var b=this.getPaths().getLength();for(var d=0;d<b;d++){var n=this.getPaths().getAt(d);var k=n.getLength();var g=k-1;for(var h=0;h<k;h++){var m=n.getAt(h);var l=n.getAt(g);if(m.lng()<f.lng()&&l.lng()>=f.lng()||l.lng()<f.lng()&&m.lng()>=f.lng()){if(m.lat()+(f.lng()-m.lng())/(l.lng()-m.lng())*(l.lat()-m.lat())<f.lat()){c=!c}}g=h}}return c}}google.maps.LatLngBounds.prototype.containsLatLng=function(a){return this.contains(a)};google.maps.Marker.prototype.setFences=function(a){this.fences=a};google.maps.Marker.prototype.addFence=function(a){this.fences.push(a)};google.maps.Marker.prototype.getId=function(){return this["__gm_id"]};if(!Array.prototype.indexOf){Array.prototype.indexOf=function(c){if(this==null){throw new TypeError()}var d=Object(this);var a=d.length>>>0;if(a===0){return -1}var f=0;if(arguments.length>1){f=Number(arguments[1]);if(f!=f){f=0}else{if(f!=0&&f!=Infinity&&f!=-Infinity){f=(f>0||-1)*Math.floor(Math.abs(f))}}}if(f>=a){return -1}var b=f>=0?f:Math.max(a-Math.abs(f),0);for(;b<a;b++){if(b in d&&d[b]===c){return b}}return -1}};
